﻿using System;
using static Spectral1.BUSINESS_LOGIC.BL_Spectral;

namespace Spectral1.BUSINESS_LOGIC
{
    public class BL_KeyScaling
    {
        static public Double get_ks_sp0to100_for_value_sp0to100(Double value_sp0to100, Double ks_sp0to100)
        {
            //Returns a signed percentage 0-1
            return bounded_sp0to100((ks_sp0to100 / 100.0) * (value_sp0to100 / 100.0) * 100);
        }

        static public Int16 get_ks_sw_for_value_usp0to100(Double value_usp0to100, Double ks_sp0to100)
        {
            //Value being scaled is unsigned. 
            double value_USW_ratio = (value_usp0to100 / 100.0) * 65535; //The module's ratio is /65535 not a percentage
            return bounded_int16((ks_sp0to100 / 100.0) * value_USW_ratio);
        }

        static public Int16 get_ks_swx32_for_value_usw(UInt16 value_usw, Double ks_sp0to100)
        {
            return bounded_int16(value_usw * (ks_sp0to100 / 100.0) * 32.0);
        }

        static public Int16 get_ks_swx32_for_value_sp0to100(Double value_sp0to100, Double ks_sp0to100)
        {
            //value_sp0to100 is the value being key-scaled.
            //ks_sp0to100 is the key scaling percentage


            //Translate value_sp0to100 into a signed 16 bit range  
            double value_sp0to32767 = (value_sp0to100 / 100.0) * 32767;

            //Mutiplies value_sp0to32767 by the key-scaling percentage and also by 32 (for finer control on the module).
            double result_value = value_sp0to32767 * (ks_sp0to100 / 100.0) * 32;
            Int16 bounded_result_value = bounded_int16(result_value);
            
            return bounded_result_value;
        }

        static public Int32 key_scaled_end_time(Int32 key_scale_split_note_id, ushort end_time_ms, short end_time_ms_keyscale_upper, short end_time_ms_keyscale_lower, Int32 for_note_id)
        {
            Int32 result = 0;
            Int32 diff;
            Double KSI;

            if (for_note_id >= key_scale_split_note_id)
            {
                KSI = get_ks_swx32_for_value_usw(end_time_ms, end_time_ms_keyscale_upper)/32.0;
                diff = for_note_id - key_scale_split_note_id;
            }
            else
            {
                KSI = get_ks_swx32_for_value_usw(end_time_ms, end_time_ms_keyscale_lower)/32.0;
                diff = key_scale_split_note_id - for_note_id;
            }
            result = Convert.ToInt32(end_time_ms + (Int32)(diff * KSI));
            return (Int32)result;
        }

        static public Double key_scaled_depth_env_target_usp0to100(Int32 key_scale_split_note_id, Double depth_env_target_usp0to100, Double depth_env_target_keyscale_upper_sp0to100, Double depth_env_target_keyscale_lower_sp0to100, Int32 for_note_id)
        {
            Double result = 0;
            Int32 diff;

            if (for_note_id >= key_scale_split_note_id)
            {
                diff = for_note_id - key_scale_split_note_id;
                result = bounded_usp0to100(depth_env_target_usp0to100 + (diff * get_ks_sp0to100_for_value_sp0to100(depth_env_target_usp0to100, depth_env_target_keyscale_upper_sp0to100)));
            }
            else
            {
                diff = key_scale_split_note_id - for_note_id;
                result = bounded_usp0to100(depth_env_target_usp0to100 + (diff * get_ks_sp0to100_for_value_sp0to100(depth_env_target_usp0to100, depth_env_target_keyscale_lower_sp0to100)));
            }
            return result;
        }

        static public Int32 key_scaled_depth_env_lin_delta_usw(Int32 key_scale_split_note_id, Int32 depth_env_lin_delta_usw, double depth_env_lin_delta_keyscale_upper_sp0to100, double depth_env_lin_delta_keyscale_lower_sp0to100, Int32 for_note_id)
        {
            Int32 result = 0;
            Int32 diff;

            if (for_note_id >= key_scale_split_note_id)
            {
                diff = for_note_id - key_scale_split_note_id;
                result = Convert.ToInt32(bounded_uint16(depth_env_lin_delta_usw + (diff * get_ks_swx32_for_value_usw((UInt16)depth_env_lin_delta_usw, depth_env_lin_delta_keyscale_upper_sp0to100) >> 5)));
            }
            else
            {
                diff = key_scale_split_note_id - for_note_id;
                result = Convert.ToInt32(bounded_uint16(depth_env_lin_delta_usw + (diff * get_ks_swx32_for_value_usw((UInt16)depth_env_lin_delta_usw, depth_env_lin_delta_keyscale_lower_sp0to100) >> 5)));
            }
            return result;
        }
        static public Double key_scaled_depth_env_exp_multiplier_usp0to100(Int32 key_scale_split_note_id, Double depth_env_exp_multiplier_usp0to100, Double depth_env_exp_multiplier_keyscale_upper_sp0to100, Double depth_env_exp_multiplier_keyscale_lower_sp0to100, Int32 for_note_id)
        {
            Double result = 0;
            Int32 diff;

            if (for_note_id >= key_scale_split_note_id)
            {
                diff = for_note_id - key_scale_split_note_id;
                //NOTE: Because the module uses ks_swx32 an this can be bounded then use this as starting point
                Double key_scaled_value_sw32 = get_ks_swx32_for_value_sp0to100(depth_env_exp_multiplier_usp0to100, depth_env_exp_multiplier_keyscale_upper_sp0to100);
                Double key_scaled_value_sp0to100 = (key_scaled_value_sw32/32)/655.35;
                result = bounded_usp0to100(depth_env_exp_multiplier_usp0to100 + (diff * key_scaled_value_sp0to100));
            }
            else
            {
                diff = key_scale_split_note_id - for_note_id;
                result = bounded_usp0to200(depth_env_exp_multiplier_usp0to100 + (diff * get_ks_swx32_for_value_sp0to100(depth_env_exp_multiplier_usp0to100, depth_env_exp_multiplier_keyscale_lower_sp0to100) >> 5));
            }
            return result;
        }


    }
}
